//	CFilePas.h

#ifndef _H_CFilePas
#define _H_CFilePas

#include "PasStructs.h"
#include "CFile.h"

Pas_DateRec		Pas_MacToPasDate(DateTimeRec *macP, Pas_DateRec *pasP);
DateTimeRec		*Pas_PasToMacDate(Pas_DateRec *pasP, DateTimeRec *macP);

char		*Pas_GetName(Pas_DirEntry *entryP, char *buf);

class CFilePas : public CFile {
	
	public:
	
	OSErr		IFilePas(
		CDiskPas			*cDisk, 
		CFolderPas			*cParentFolderPas, 
		Pas_BlockNum		block, 
		Pas_EntryIndex		diskLocDirEntryIndex,	//	relative to cur dir sector
		Pas_EntryIndex		directoryIndex);		//	relative to entire directory
	
	Pas_DirEntry		*GetMyEntry(void);
	
	virtual	ushort		GetLoadAddress(void);
	virtual	void		SetLoadAddress(ushort address);
	
	virtual char		*GetDescription(char *buf);

	virtual ulong		GetPhysicalSize(void);
	virtual ulong		GetLogicalSize(void);

	virtual	DateTimeRec	*GetModifiedTime(DateTimeRec *dt);
	virtual	void		SetModifiedTime(DateTimeRec *dt);

	virtual	char		*GetName(char *buf);
	virtual	void		SetName(char *buf);
	
	virtual	OSErr 		ReadFile(Byte *buffer, long length);
	virtual	OSErr 		WriteFile(Byte *buffer, long length);
	virtual ADFS_IconType		GetIconType(void);

	virtual	ushort		GetFileType_ProEquiv(void);

	virtual	ushort		GetFileType(void);
	Pas_FileKindType	GetPasFileType(void);

	virtual	OSErr		Pas_GetIndBlockNum(
			Pas_BlockNum blockIndex, 
			Pas_BlockNum *blockNum);
			
	virtual	ulong		ADFS_GetBufSize(void);
	virtual	OSErr		ADFS_Open(
		ADFS_IOType	ioType, 
		Boolean		resForkB, 
		char		**bufferP, 
		ulong		*bufSize);

	virtual	OSErr		ADFS_Read(ushort *bytesRead);
	virtual	OSErr		ADFS_Write(ushort *bytesWritten);
	virtual	OSErr		ADFS_Close(void);

	OSErr	Pas_WriteBlock(
		ushort			numBytesS, 
		Pas_Block		*block);

	virtual	OSErr		EntryPane_CB_EntryArray(
		TA_IterateType taType, TA_IterateData *cbData);

	OSErr				MoveFileDown(Pas_BlockNum *firstFreeBlock);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	OSErr		GetFileBlocks(
		Pas_BlockNum	*fileBlockA0, 
		Pas_BlockNum	*numFileBlocksSP);

	OSErr		GetEntryAlloc(
		Boolean			getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	Boolean		i_dle_straddleB;
	
	private:
	typedef CFile _inherited;
};

#endif
